# **The Institute for Palestine Studies: Documenting and Targeting Destruction of the Health Sector in the Gaza Strip**

[![Website screenshot][image1]](https://gazahcsector.palestine-studies.org/en)  
 

### **Reviewed by:** Alexandra Millatmal 

### **Review date:** March 26, 2025

### **Site Links**: 

* [https://gazahcsector.palestine-studies.org/en](https://gazahcsector.palestine-studies.org/en)   
* [https://www.palestine-studies.org/en/digital-projects](https://www.palestine-studies.org/en/digital-projects) 

### **Archive Link:** 
* Documenting the Targeting and Destruction of the Health Sector in the Gaza Strip: [https://archive.ph/mkvsN](https://archive.ph/mkvsN)  
* Institute for Palestinian Studies  Digital Projects home page: [https://archive.ph/aKv0D](https://archive.ph/aKv0D)

### **Keywords:** Archiving, Activism and Advocacy, First Nations and Indigenous Studies, Palestine Studies, Postcolonial Studies, Preservation

### **Data Sources:** 
* Second-hand public records (from sources including the United Nations, World Health Organization, the Palestinian Ministry of Health, non-governmental organizations, news media)  
* First-hand audio and video testimonies  
* Policy papers  
* Summarizations/biographies of health care workers who were abducted, killed, or disappeared  
* Social media profiles, posts, and videos

### **Processes:** 
* Collating  
* Categorizing  
* Summarizing

### **Presentation:** 
The project is a website that collects and organizes information about health facilities in Gaza and the ways they and their workers have been impacted by Israel’s siege on the occupied territory, specifically since October 2023\. The site features sections on facilities, workers, public records of [medelacide](https://bristoluniversitypressdigital.com/gsc/view/journals/gscj/aop/article-10.1332-27523349Y2025D000000037/article-10.1332-27523349Y2025D000000037.xml) (the intentional and systematic destruction of healthcare infrastructure; Mueller, 2025\) policy papers, testimonials, and analysis blogs. Materials exist in both English and Arabic.

### **Digital Tools Used:** 
* Cloudflare hosting  
* Drupal CMS  
* HTML and jQuery

### **Languages:** 
* Arabic  
* English

### **Review**  
The project [Documenting the Targeting and Destruction of the Health Sector in the Gaza Strip](https://gazahcsector.palestine-studies.org/en) aims to provide “comprehensive information on the most horrific assault on health in the history of the Palestinian struggle” and serve as an archival resource for researchers. It self-describes as a work-in-progress, reliant on secondary sources in its first iteration. It is one of a number of digital projects developed by the [Institute for Palestinian Studies](https://www.palestine-studies.org/) (IPS), an academic organization headquartered in Beirut.

<br>
The site is composed of five distinct sections: [Health Facilities](https://gazahcsector.palestine-studies.org/en/healthFacilities), [Health Workers](https://gazahcsector.palestine-studies.org/en/medical_teams), [Public Records](https://gazahcsector.palestine-studies.org/en/PublicRecords), [Testimonies from the Genocide](https://gazahcsector.palestine-studies.org/en/testimonies), and [Policy Papers and Analysis](https://gazahcsector.palestine-studies.org/en/papers). Each section provides a different lens from which to view data on — almost like different cross-sections of — the same unfolding phenomenon: the unchecked, real-time obliteration of Gaza’s civil society infrastructure by the Israeli Occupation Forces.

<br>
The Health Facilities section documents every facility that was once operating in the Gaza Strip, its type, ownership, governorates in which it operates, capacity, and founding date. Each facility has its own standalone asset page that provides further details, like descriptions, tags for the type of specialized practices and equipment, related testimonies, and a timeline of major targeting and assault of the facility during the ongoing genocide. Each facility is listed as functional, partially functional, or non-functional.

<br>
The Health Workers section features pictures and short biographies of medical workers in Gaza who have been disappeared, killed, abducted, and — rarely — released. Each person’s stand-alone biography page features a photo and birthday, as well as a list of sources and key events related to this person, and a link to the page of the medical facility where they worked. Rarely, as in the case of Muhammad Abu Salamiya and his release from Israeli detention, there are related video testimonials.

<br>
The Public Records section features a collection of secondary sources reporting on the attacks on healthcare facilities and workers, listed in chronological order and most-often linking out to a digitized PDF of the report (though sometimes the report text is copied in as text on a standalone asset page within the site). 

<br>
The Policy Papers and analysis section is seemingly the most straight-forward, with papers from the IPS academic journal and blog posts written in both English and Arabic, as well as past lecture series in Arabic, and frontline video recorded statements and analyses from doctors working in Gaza.

<br>
The Testimonies from the Genocide page features primary-source Arabic-language video testimony from health care workers in Gaza. Some of these videos have metadata like subject tags, descriptions, and the name and role of the testifier, though others do not. Many appear to be pulled from social media. Few videos have in-video transcription or captioning and none are yet translated into English.  

<br>
While I would argue that the site’s greatest strength is its composability, and the ways that different pieces of the record can be arranged to inform one another — a testimony may appear in the aggregate collection of testimonies, and on a facility page, and on a biography page — it’s also a little hard to see the data from a birds’ eye view. This makes perfect sense given it is detailing currently unfolding war crimes during an active genocide, and I’m curious to know if there have been any comparable real-time archiving projects of similar kinds of destruction. 

<br>
The project meets its goals quite well, and I take particular note of the variety of sources that provide the site its meaning. A policy paper by Jasbir K. Paur is available to review and cite, alongside UN reports and a memorial Facebook post from a Gazan doctor’s association. This project feels like an invaluable collection that is waiting for expansion, further refinement and categorization, and some meta-analysis.  

### **How are the collaborative aspects reflected in the project and are there elements that work particularly well?**
It is clear that the institutional prominence of the IPS helps in developing resources for the site, particularly when it comes to recorded analysis panels and publications. It’s also just so clear that there is an importance to this kind of testimonial, witnessing, and record-keeping across both institutional and interpersonal players in Palestine, and those different registers of public record all come together in this project.  

### **Do you see an opportunity for collaboration that would be helpful to the project?** 
I think there could be an opportunity for researchers who are less directly impacted by the ongoing violence in Gaza to help by adding organization to some of the records of the site — for example, help display updates to facilities on a timeline, or place incidents on some kind of time lapsed map — in order to provide users more angles from which to consider the data. Additionally, there is also the need to transcribe and translate site video material.

<br>
**Citation**  
Mueller, J. C. (2025). Medelacide: the intentional and systematic destruction of healthcare infrastructure. *Global Social Challenges Journal* (published online ahead of print 2025). Retrieved Mar 29, 2025, from [https://doi.org/10.1332/27523349Y2025D000000037](https://doi.org/10.1332/27523349Y2025D000000037)  


[image1]: <data:image/png;base64,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>